clear all
close all

load('CameraPoints_20160319_Phantom.mat')
load('PAindex_20160319_Phantom.mat')

%%% 1-10
x1_10 = point3DL(1,1:10)';
y1_10 = point3DL(2,1:10)';
z1_10 = point3DL(3,1:10)';

%%% 11-20
x11_20 = point3DL(1,11:20)';
y11_20 = point3DL(2,11:20)';
z11_20 = point3DL(3,11:20)';

%%% 21-30
x21_30 = point3DL(1,21:30)';
y21_30 = point3DL(2,21:30)';
z21_30 = point3DL(3,21:30)';

%% Do linear regression on y as a function of x, ignoring z

%%% 1-10

%%% 1st Order Fit
p1_xy1_10 = polyfit(x1_10,y1_10,1);
y1_1_10 = polyval(p1_xy1_10, x1_10);
% %%% 2nd Order Fit
% p2_xy1_10 = polyfit(x1_10,y1_10,2);
% y2_1_10 = polyval(p2_xy1_10, x1_10);
% %%% 3rd Order Fit
% p3_xy1_10 = polyfit(x1_10,y1_10,3);
% y3_1_10 = polyval(p3_xy1_10, x1_10);
% %%% Logarithmic Fit
% p4_xy1_10 = polyfit(x1_10,log(y1_10),1);
% y4_1_10 = polyval(p4_xy1_10, x1_10);

%%% Residual

%%% 1st Order Fit
res1_xy1_10 = y1_10-y1_1_10;

% figure
% subplot(2,2,1), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y1_1_10,'k--'), grid on, title('1st Order Fit')
% subplot(2,2,2), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y2_1_10,'k--'), grid on, title('2nd Order Fit')
% subplot(2,2,3), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y3_1_10,'k--'), grid on, title('3rd Order Fit')
% subplot(2,2,4), plot(x1_10,log(y1_10),'ko'), hold on, plot(x1_10,y4_1_10,'k--'), grid on, title('Logarithmic Fit')

figure(1)
plot(x1_10,y1_10,'o',x1_10,y1_1_10), title('1st Order Fit for xy 1-10') 
% figure(2)
% plot(x1_10,res1_xy1_10,'+')


%%% 11-20

%%% 1st Order Fit
p1_xy11_20 = polyfit(x11_20,y11_20,1);
y1_11_20 = polyval(p1_xy11_20, x11_20);
% %%% 2nd Order Fit
% p2_xy1_10 = polyfit(x1_10,y1_10,2);
% y2_1_10 = polyval(p2_xy1_10, x1_10);
% %%% 3rd Order Fit
% p3_xy1_10 = polyfit(x1_10,y1_10,3);
% y3_1_10 = polyval(p3_xy1_10, x1_10);
% %%% Logarithmic Fit
% p4_xy1_10 = polyfit(x1_10,log(y1_10),1);
% y4_1_10 = polyval(p4_xy1_10, x1_10);

%%% Residual

%%% 1st Order Fit
res1_xy11_20 = y11_20-y1_11_20;

% figure
% subplot(2,2,1), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y1_1_10,'k--'), grid on, title('1st Order Fit')
% subplot(2,2,2), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y2_1_10,'k--'), grid on, title('2nd Order Fit')
% subplot(2,2,3), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y3_1_10,'k--'), grid on, title('3rd Order Fit')
% subplot(2,2,4), plot(x1_10,log(y1_10),'ko'), hold on, plot(x1_10,y4_1_10,'k--'), grid on, title('Logarithmic Fit')

figure(3)
plot(x11_20,y11_20,'o',x11_20,y1_11_20), title('1st Order Fit for xy 11-20') 
% figure(4)
% plot(x11_20,res1_xy11_20,'+')


%%% 21-30

%%% 1st Order Fit
p1_xy21_30 = polyfit(x21_30,y21_30,1);
y1_21_30 = polyval(p1_xy21_30, x21_30);
% %%% 2nd Order Fit
% p2_xy1_10 = polyfit(x1_10,y1_10,2);
% y2_1_10 = polyval(p2_xy1_10, x1_10);
% %%% 3rd Order Fit
% p3_xy1_10 = polyfit(x1_10,y1_10,3);
% y3_1_10 = polyval(p3_xy1_10, x1_10);
% %%% Logarithmic Fit
% p4_xy1_10 = polyfit(x1_10,log(y1_10),1);
% y4_1_10 = polyval(p4_xy1_10, x1_10);

%%% Residual

%%% 1st Order Fit
res1_xy21_30 = y21_30-y1_21_30;

% figure
% subplot(2,2,1), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y1_1_10,'k--'), grid on, title('1st Order Fit')
% subplot(2,2,2), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y2_1_10,'k--'), grid on, title('2nd Order Fit')
% subplot(2,2,3), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y3_1_10,'k--'), grid on, title('3rd Order Fit')
% subplot(2,2,4), plot(x1_10,log(y1_10),'ko'), hold on, plot(x1_10,y4_1_10,'k--'), grid on, title('Logarithmic Fit')

figure(5)
plot(x21_30,y21_30,'o',x21_30,y1_21_30), title('1st Order Fit for xy 21-30') 
% figure(6)
% plot(x21_30,res1_xy21_30,'+')



%% Do linear regression on z as a function of x, ignoring y

%%% 1-10

%%% 1st Order Fit
p1_xz1_10 = polyfit(x1_10,z1_10,1);
z1_1_10 = polyval(p1_xz1_10, x1_10);
% %%% 2nd Order Fit
% p2_xy1_10 = polyfit(x1_10,y1_10,2);
% y2_1_10 = polyval(p2_xy1_10, x1_10);
% %%% 3rd Order Fit
% p3_xy1_10 = polyfit(x1_10,y1_10,3);
% y3_1_10 = polyval(p3_xy1_10, x1_10);
% %%% Logarithmic Fit
% p4_xy1_10 = polyfit(x1_10,log(y1_10),1);
% y4_1_10 = polyval(p4_xy1_10, x1_10);

%%% Residual

%%% 1st Order Fit
res1_xz1_10 = z1_10-z1_1_10;

% figure
% subplot(2,2,1), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y1_1_10,'k--'), grid on, title('1st Order Fit')
% subplot(2,2,2), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y2_1_10,'k--'), grid on, title('2nd Order Fit')
% subplot(2,2,3), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y3_1_10,'k--'), grid on, title('3rd Order Fit')
% subplot(2,2,4), plot(x1_10,log(y1_10),'ko'), hold on, plot(x1_10,y4_1_10,'k--'), grid on, title('Logarithmic Fit')

figure(7)
plot(x1_10,z1_10,'o',x1_10,z1_1_10), title('1st Order Fit for xz 1-10') 
% figure(2)
% plot(x1_10,res1_xz1_10,'+')


%%% 11-20

%%% 1st Order Fit
p1_xz11_20 = polyfit(x11_20,z11_20,1);
z1_11_20 = polyval(p1_xz11_20, x11_20);
% %%% 2nd Order Fit
% p2_xy1_10 = polyfit(x1_10,y1_10,2);
% y2_1_10 = polyval(p2_xy1_10, x1_10);
% %%% 3rd Order Fit
% p3_xy1_10 = polyfit(x1_10,y1_10,3);
% y3_1_10 = polyval(p3_xy1_10, x1_10);
% %%% Logarithmic Fit
% p4_xy1_10 = polyfit(x1_10,log(y1_10),1);
% y4_1_10 = polyval(p4_xy1_10, x1_10);

%%% Residual

%%% 1st Order Fit
res1_xz11_20 = z11_20-z1_11_20;

% figure
% subplot(2,2,1), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y1_1_10,'k--'), grid on, title('1st Order Fit')
% subplot(2,2,2), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y2_1_10,'k--'), grid on, title('2nd Order Fit')
% subplot(2,2,3), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y3_1_10,'k--'), grid on, title('3rd Order Fit')
% subplot(2,2,4), plot(x1_10,log(y1_10),'ko'), hold on, plot(x1_10,y4_1_10,'k--'), grid on, title('Logarithmic Fit')

figure(9)
plot(x11_20,z11_20,'o',x11_20,z1_11_20), title('1st Order Fit for xz 11-20') 
% figure(4)
% plot(x11_20,res1_xz11_20,'+')


%%% 21-30

%%% 1st Order Fit
p1_xz21_30 = polyfit(x21_30,z21_30,1);
z1_21_30 = polyval(p1_xz21_30, x21_30);
% %%% 2nd Order Fit
% p2_xy1_10 = polyfit(x1_10,y1_10,2);
% y2_1_10 = polyval(p2_xy1_10, x1_10);
% %%% 3rd Order Fit
% p3_xy1_10 = polyfit(x1_10,y1_10,3);
% y3_1_10 = polyval(p3_xy1_10, x1_10);
% %%% Logarithmic Fit
% p4_xy1_10 = polyfit(x1_10,log(y1_10),1);
% y4_1_10 = polyval(p4_xy1_10, x1_10);

%%% Residual

%%% 1st Order Fit
res1_xz21_30 = z21_30-z1_21_30;

% figure
% subplot(2,2,1), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y1_1_10,'k--'), grid on, title('1st Order Fit')
% subplot(2,2,2), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y2_1_10,'k--'), grid on, title('2nd Order Fit')
% subplot(2,2,3), plot(x1_10,y1_10,'ko'), hold on, plot(x1_10,y3_1_10,'k--'), grid on, title('3rd Order Fit')
% subplot(2,2,4), plot(x1_10,log(y1_10),'ko'), hold on, plot(x1_10,y4_1_10,'k--'), grid on, title('Logarithmic Fit')

figure(11)
plot(x21_30,z21_30,'o',x21_30,z1_21_30), title('1st Order Fit for xz 21-30') 
% figure(6)
% plot(x21_30,res1_xz21_30,'+')


%% Combine the two resulting lines of regression

%%% one expressing y as a linear function of x, and the other z as a 
%%% linear function of x, can then be considered combined as a single line in three dimensions

%%% 1-10
point3DL(1,1:10) = x1_10';
point3DL(2,1:10) = y1_1_10';
point3DL(3,1:10) = z1_1_10';

%%% 11-20
point3DL(1,11:20) = x11_20';
point3DL(2,11:20) = y1_11_20';
point3DL(3,11:20) = z1_11_20';

%%% 21-30
point3DL(1,21:30) = x21_30';
point3DL(2,21:30) = y1_21_30';
point3DL(3,21:30) = z1_21_30';


